package de.Android_Seminar.xmlCreator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.util.Log;
import android.util.Xml;
import de.Android_Seminar.backend.SensorController;
import de.Android_Seminar.backend.SensorData;
import de.Android_Seminar.backend.SensorType;

public class XmlCreator implements Runnable{
	
	/** the {@link SensorController} where all the data will be obtained from **/
	private SensorController sensorController;	
	
	/** the file with it's path, where the xml file should be saved to. 
	 *  The file should have the format: sdcard/path/filename.xml
	**/
	private String file;
	
	/** the tag of the activity **/
	private String tag;
	
	/** flag that states if a recording is taking place **/
	private boolean isRecording;
	
	/** sample rate; time minimal between two data sets **/
	private static final int SAMPLE_RATE = 100;
	
	/** the user **/
	private static final int USER = 1; 
	
	/** an instance for a {@ FileTransmitter} thread **/
	private Thread thisThread;
	
	/**
	 * constructor
	 * @param sensorController the {@link SensorController} where all the data will be obtained from
	 */
	public XmlCreator(SensorController sensorController) {
		
		this.sensorController = sensorController;
	}
	
	/**
	 * run method of this thread
	 */
	public void run() {
		
		startNewFile();	
		
		startWriting();		
		Log.d("status", "WRITING to XML");
		
		while(isRecording) {
			
			
			writeSensorData();
			
			try {
				Thread.sleep(SAMPLE_RATE);
			} catch (InterruptedException e) {
			}
			
		}
		endWriting();
		endFile();
	}
	
	/**
	 * 
	 */
	private void startNewFile() {
		
		createFolder();
		
		try {
			FileWriter fw = null;
			
			fw = new FileWriter( file , false );
			PrintWriter pw = new PrintWriter( fw );

			pw.println("<?xml version=\"1.0\"?>");
			
			
			String tag = "NULL";
						
			if(this.tag != null)
				tag = this.tag;
			
			String user = Integer.toString(USER);
			
			pw.println("<activity tag=\"" +tag +"\" username=\"" +user +"\" startTime=\"" +System.currentTimeMillis() +"\" endTime=\"-1\" >");
			fw.flush();
			
			fw.close();
			pw.flush();
			pw.close();
		
		} catch (IOException e) {
			Log.d("error", e.getMessage());
			e.printStackTrace();
		}	
	}
	
	
	FileWriter fw = null;
	PrintWriter pw;
	/**
	 * 
	 */
	private void startWriting() {
		
		
		try {
			
			Log.d("status", "new FW");
			
			fw = new FileWriter( file , true );
			Log.d("status", "fw: " +fw);
			pw = new PrintWriter( fw );
			
			Log.d("status", "fw: " +fw);
			
		} catch (IOException e) {
			e.printStackTrace();
			Log.d("Status", "ERROR: " +e.toString());
		}
		
	}
	
	/**
	 * 
	 */
	private void endWriting() {
		
		
		try {
			
			fw.close();
			pw.flush();
			pw.close();
			
		} catch (IOException e) {
			Log.d("Status", "ERROR: " +e.toString());
			e.printStackTrace();
		}
		
	}
	
	
	/**
	 * writes sensor data to a xml file
	 */
	private void writeSensorData() {		
		
		List<SensorType> sensors = sensorController.getActiveSensors();
		
		String[] sensorData = new String[sensors.size()];
		SensorData data;
		for(int j=0; j<sensors.size(); j++) {
			
			data = sensorController.getCurrentData(sensors.get(j));
			
			String xmlTag = "<data ";
			xmlTag = xmlTag +"sensor=\"" +data.getSensorType() +"\" ";
			xmlTag = xmlTag +"time=\"" +data.getTimeStamp().getTime() +"\" ";
			xmlTag = xmlTag +"valueAmount=\"" +data.getLength() +"\" ";
			for(int i=0; i<data.getLength(); i++) 
				xmlTag = xmlTag +"v" +(i+1) +"=\"" +data.getValues()[i] +"\" ";
			xmlTag = xmlTag +"longitude=\"0\" ";
			xmlTag = xmlTag +"latitude=\"0\" ";
			xmlTag = xmlTag +"altitude=\"0\" ";
			xmlTag = xmlTag +"/>";
			
			sensorData[j] = xmlTag;			
		}
		
		try {

			if(pw != null) {
				pw.println("\t " +"<dataset>");
				
				for(int i=0; i<sensorData.length; i++)
					pw.println("\t \t" +sensorData[i]);
				
							
				pw.println("\t " +"</dataset>");
			}
			
//			Log.d("status", "fw: " +fw);
			
			fw.flush();
		
		} catch (IOException e) {
			Log.d("Status", "ERROR: " +e.toString());
			Log.d("error", e.getMessage());
			e.printStackTrace();
		}			
	}
	
	/**
	 * ent writing the xml file
	 */
	private void endFile() {
		try {
			FileWriter fw = null;
			fw = new FileWriter( file , true );
			PrintWriter pw = new PrintWriter( fw );

			pw.println("</activity>");
			
			fw.flush();
			
			fw.close();
			pw.flush();
			pw.close();
		
		} catch (IOException e) {
			Log.d("error", e.getMessage());
			e.printStackTrace();
		}	
	}
	
	
	
	/**
	 * 
	 * @param file
	 */
	public void startRecording() {
		
		startRecording(null);
	}
	
	/**
	 * 
	 * @param file
	 * @param tag
	 */
	public void startRecording(String tag) {
		
		Log.d("methodStack", "XmlCreator - startRecording()");
		
		if(tag == "")
			tag = null;
		
		this.tag = tag;
		
		if(sensorController.getActiveSensors().size() <= 0)
			return;
		
		this.file = Environment.getExternalStorageDirectory() + "/activityDiary/" +"activity" +getNextFileNameIndex() +".xml";
		
		isRecording = true;
		
		thisThread = new Thread(this);
		thisThread.start();	
	}
	
	
	
	/**
	 * stops a current recording
	 */
	public void stopRecording() {
		
		isRecording = false;		
	}
	
	/**
	 * tags a activity (xml file) with a given tag
	 * @param tag the tag, the activity should be tagged with
	 * @param file the path and file name of the activity that should be tagged
	 * (path and file name of the xml file) 
	 * @param startTime
	 * @param endTime
	 */
	public void tagActivity(String tag, String file, long startTime, long endTime) {
				
		
		String fileName = Environment.getExternalStorageDirectory() + "/activityDiary/" +file;
		
		if(isTagged(fileName) || !isXmlFile(fileName))
			return;
		
		if(startTime > endTime)
			throw new IllegalArgumentException("wrong time spcification: start time:" +startTime +" is not smaller than end time: " +endTime);
		
		long startLine = findStartTag(fileName, startTime);
		long endLine = findEndTag(fileName, endTime);
		
		
		
		
		try {
			
			BufferedReader in = new BufferedReader(new FileReader(fileName));
            if (!in.ready())
                throw new IOException();
            
            FileWriter fw = null;
            PrintWriter pw;
			
		// writing lines startLine - endLine into new xml file (file1)

			fw = new FileWriter( "sdcard/activityDiary/activity" +getNextFileNameIndex() +".xml" , false );
			pw = new PrintWriter( fw );
			
			pw.println("<?xml version=\"1.0\"?>");
			pw.println("<activity tag=\"" +tag +"\" username=\"" +USER +"\" startTime=\"" +startTime +"\" endTime=\"" +endTime +"\">");
			fw.flush();

			int lineNumber = 0;
            String line = in.readLine();
            while ( line != null) {
            	
            	if(lineNumber >= startLine && lineNumber <= endLine) {
            		pw.println(line);
            		fw.flush();
            	}            	
            	
            	lineNumber++;
            	line = in.readLine();
            }
            
            pw.println("</activity>");
            
            fw.flush();
			fw.close();
			pw.flush();
			pw.close();
            in.close();
            
            
            
            // wrinting old data:
            
            in = new BufferedReader(new FileReader(fileName));
            if (!in.ready())
                throw new IOException();
            
            String newFileName = Environment.getExternalStorageDirectory() + "/activityDiary/activity" +getNextFileNameIndex() +".xml";
            fw = new FileWriter( newFileName , false );
			pw = new PrintWriter( fw );
			

			lineNumber = 0;
            line = in.readLine();
            while ( line != null) {
            	
            	if(!(lineNumber >= startLine && lineNumber <= endLine)) {
            		pw.println(line);
            		fw.flush();
            	}            	
            	
            	lineNumber++;
            	line = in.readLine();
            }
            
            fw.flush();
			fw.close();
			pw.flush();
			pw.close();
            in.close();
            
            
            // rename old file:
            File oldFile = new File(fileName);            
            File newFile = new File(newFileName);
            newFile.renameTo(oldFile);
            
            // xml file is empty:
            if(!xmlIsNotEmpty(fileName)) {
            	oldFile.delete();
            }    
		
		} catch (IOException e) {
			Log.d("error", e.getMessage());
			e.printStackTrace();
		}				
	}
	
		
	/**
	 * This method returns a list with all the available activities 
	 * (xml files that already have been tagged)
	 * This names only consists of the file name without a path
	 * @return the file name of the corresponding xml file
	 */
	public LinkedList<String> getXmlActivities() {
		
		LinkedList<String> activities = new LinkedList<String>();
		
		String path = Environment.getExternalStorageDirectory() + "/activityDiary/";
		File folder = new File(path);
		String[] files = folder.list();
		
		if(files == null)
			return null;
		
		for(int i=0; i<files.length; i++) {
			
			if((files[i].toLowerCase()).endsWith(".xml")) {
				if(isTagged(path+files[i]))
					activities.add(files[i]);
			}
		}
		
		return activities;
	}
	
	/**
	 * This method returns a list with all the xml files
	 * that have not been tagged, yet. 
	 * This names only consists of the file name without a path.
	 * @return the file name of the corresponding xml file
	 */
	public LinkedList<String> getXmlRawData() {
		
		LinkedList<String> activities = new LinkedList<String>();
		
		String path = Environment.getExternalStorageDirectory() + "/activityDiary/";
		File folder = new File(path);
		String[] files = folder.list();
		
		if(files == null)
			return null;
		
		for(int i=0; i<files.length; i++) {
			
			if((files[i].toLowerCase()).endsWith(".xml")) {
				if(!isTagged(path+files[i]))
					activities.add(files[i]);
			}
		}
		
		return activities;
	}

	
	
	/**
	 * 
	 * @param file the file name of the xml file that contains the activity
	 * This file name must consist only of the file's name, not of it's path 
	 * @return the name of the activity, or null if the data have not been tagged, yet
	 */
	public String getActivityName(String file) {
				
		String activity = Environment.getExternalStorageDirectory() + "/activityDiary/" +file; 
		
		if(!isTagged(activity))
			return null;
		
		file  = Environment.getExternalStorageDirectory() + "/activityDiary/" +file;
				
		URL url;
		try {
			url = new URL("file:///" +file);
				
		XmlPullParser parser = Xml.newPullParser();
        
		try {
			parser.setInput(url.openStream(), null);
			
			
			int event_type = parser.getEventType();
			boolean done = false;
			String name = null;			
			
			while (event_type != XmlResourceParser.END_DOCUMENT && !done){
				
				name = parser.getName();
				
				switch (event_type){
					case XmlResourceParser.START_DOCUMENT:
						
						break;
						
					case XmlResourceParser.START_TAG:
						
						if(name.equalsIgnoreCase("activity")) {
							return parser.getAttributeValue(null, "tag");
						}
						
						break;
						
					case XmlResourceParser.END_TAG:

						break;
				}
				
				event_type = parser.next();
			}
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			// file does not exists; do not change anything
			Log.d("status", "XmlCreator - file does not exists: " +"file:///"+file);
			e.printStackTrace();
		}
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		
		return null;
	}
	

	/**
	 * 
	 * @param file the file name of the xml file that contains the activity
	 * This file name must consist only of the file's name, not of it's path 
	 * @return the start time of an tagged or untagged activity
	 * -1 if no time was set.
	 */
	public long getActivityStartTime(String file) {
		
		file = Environment.getExternalStorageDirectory() + "/activityDiary/" +file;
		
		URL url;
		try {
			url = new URL("file:///" +file);
				
		XmlPullParser parser = Xml.newPullParser();
        
		try {
			parser.setInput(url.openStream(), null);
			
			
			int event_type = parser.getEventType();
			boolean done = false;
			String name = null;			
			
			while (event_type != XmlResourceParser.END_DOCUMENT && !done){
				
				name = parser.getName();
				
				switch (event_type){
					case XmlResourceParser.START_DOCUMENT:
						
						break;
						
					case XmlResourceParser.START_TAG:
						
						if(name.equalsIgnoreCase("activity")){
							String timeString = parser.getAttributeValue(null, "startTime");
							if(timeString != null ) {
								return Long.parseLong(timeString);
							}
							return -1;
						}				
												
						break;
						
					case XmlResourceParser.END_TAG:

						break;
				}
				
				event_type = parser.next();
			}
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			// file does not exists; do not change anything
			Log.d("status", "XmlCreator - file does not exists: " +"file:///"+file);
			e.printStackTrace();
		}
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		
		return -1L;
		
	}
	
	/**
	 * 
	 * @param file the file name of the xml file that contains the activity
	 * This file name must consist only of the file's name, not of it's path 
	 * @return the end time of an tagged or untagged activity
	 * -1 if no time was set.
	 */
	public long getActivityEndTime(String file) {
		
		file = Environment.getExternalStorageDirectory() + "/activityDiary/" +file;
		
		URL url;
		try {
			url = new URL("file:///" +file);
				
		XmlPullParser parser = Xml.newPullParser();
        
		try {
			parser.setInput(url.openStream(), null);
			
			
			int event_type = parser.getEventType();
			boolean done = false;
			String name = null;			
			
			while (event_type != XmlResourceParser.END_DOCUMENT && !done){
				
				name = parser.getName();
				
				switch (event_type){
					case XmlResourceParser.START_DOCUMENT:
						
						break;
						
					case XmlResourceParser.START_TAG:
						
						if(name.equalsIgnoreCase("activity")){
							String timeString = parser.getAttributeValue(null, "endTime");
							if(timeString != null ) {
								long endTime = Long.parseLong(timeString);
								if(endTime >= 0)
									return endTime;
								
								return getRawDataEndTime(file);								
							}
							return -1;
						}				
												
						break;
						
					case XmlResourceParser.END_TAG:

						break;
				}
				
				event_type = parser.next();
			}
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			// file does not exists; do not change anything
			Log.d("status", "XmlCreator - file does not exists: " +"file:///"+file);
			e.printStackTrace();
		}
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		
		return -1L;
		
	}
	
	/**
	 * Determines if a recording is running
	 */
	public boolean isRecording() {
		
		return isRecording;
	}
	
	/**
	 * deletes an xml file
	 * @param file the file that should be deleted
	 * This file name must consist only of the file's name, not of it's path
	 */
	public boolean deleteXmlFile(String file) {
		
		file = Environment.getExternalStorageDirectory() + "/activityDiary/" +file;
		boolean success;
		File f = new File(file);
		success = f.delete();
		return success;
	}
	
	private boolean xmlIsNotEmpty(String file) {
		
		URL url;
		int datasetTags = 0;
		int sensorAmount = 0;
		
		
		try {
			url = new URL("file:///" +file);
				
		XmlPullParser parser = Xml.newPullParser();
		
		       
		try {
			parser.setInput(url.openStream(), null);
			
			
			int event_type = parser.getEventType();
			boolean done = false;
			String name = null;
			
			while (event_type != XmlResourceParser.END_DOCUMENT && !done){
				
				name = parser.getName();
				
				switch (event_type){
					case XmlResourceParser.START_DOCUMENT:
						
						break;
						
					case XmlResourceParser.START_TAG:
						
						if(name.equalsIgnoreCase("dataset")) 
							datasetTags++;
						
						if(name.equalsIgnoreCase("data")) {
							String valueAmountString = parser.getAttributeValue(null, "valueAmount");
							if(valueAmountString == null)
								valueAmountString = "0";
							sensorAmount = Integer.parseInt(valueAmountString);
						}
						
						break;
						
					case XmlResourceParser.END_TAG:

						break;
				}
				
				event_type = parser.next();
			}
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			// file does not exists; do not change anything
			Log.d("status", "XmlCreator - file does not exists: " +"file:///"+file);
			e.printStackTrace();
		}
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		
		int minDataNumber = 4*sensorAmount * (SAMPLE_RATE/1000) ;
		if(datasetTags > minDataNumber) {
			return true;
		}
		
		
		return false;
	}
	
	
	/**
	 * 
	 * @return the index, the next file will have
	 */
	private int getNextFileNameIndex() {
		
		String path = Environment.getExternalStorageDirectory() + "/activityDiary/";
		File folder = new File(path);
		String[] files = folder.list();
		
		if(files == null)
			return 0;
		
		int biggestNumber = 0; 
		ArrayList<Integer> seenNumbers = new ArrayList<Integer>(files.length);
		
		int fileNumber;
		for(int i=0; i<files.length; i++) {
			if(isXmlFile(files[i]) ) {
				if((files[i]).contains("activity")) {
					if( ((files[i]).indexOf("activity")+("activity").length()) +1 == (files[i]).indexOf(".xml") ) {
						fileNumber = getFileNumber(files[i]);
						seenNumbers.add(fileNumber);
					}
				}
			}
		}
		
		while( seenNumbers.contains(biggestNumber) ) {
			biggestNumber++;
		}
		
		
		return biggestNumber;
	}
	
	private int findEndTag(String file, long endTime) {
		
		
		try
        {    
			
            BufferedReader in = new BufferedReader(new FileReader(file));
            if (!in.ready())
                throw new IOException();
            
            int lineNumber = 0;
            String line = in.readLine();
            while ( line != null) {
            	
            	if(line.contains("</activity>"))
            		return lineNumber - 1;
            	            	
            	
            	if(line.contains("<data ")) {
            		long time = retrieveTimeFromDataTag(line);
            		if(time >= endTime) {
//            			Log.d("status", "FOUND: " +lineNumber);
            			return lineNumber-2;
            		}
            	}
            	
            	            	
            	lineNumber++;
            	line = in.readLine();
            }
            	
            in.close();
        }
        catch (IOException e)
        {
            System.out.println(e);
            return -1;
        }
		
		return -1;
	}
	
	private int findStartTag(String file, long startTime) {
		
		try
        {    
			
            BufferedReader in = new BufferedReader(new FileReader(file));
            if (!in.ready())
                throw new IOException();
            
            int lineNumber = 0;
            String line = in.readLine();
            while ( line != null) {
//            	Log.d("status", "analyzing: " +line);
            	if(line.contains("<data ")) {
            		long time = retrieveTimeFromDataTag(line);
            		if(time >= startTime) {
//            			Log.d("status", "FOUND: " +lineNumber);
            			return lineNumber-1;
            		}
            	}
            	lineNumber++;
            	line = in.readLine();
            }
            	
            in.close();
        }
        catch (IOException e)
        {
            System.out.println(e);
            return -1;
        }
		
		return -1;
	}
	
	
	private long retrieveTimeFromDataTag(String tag) {
		
		if(!(tag.contains("time=\""))) 
			return -1;
		
		
		int startPos = tag.indexOf("time=\"") +("time=\"").length();
		int endPos = startPos;
		for(int i=startPos; i<tag.length(); i++) {
			if(tag.charAt(i) == ("\"").charAt(0) ) 
				break;
			
			endPos++;
		}
		
		long l = Long.parseLong(tag.substring(startPos, endPos));
		return l;
	}
	
	/**
	 * 
	 * @param file the file/activity that should be used.
	 * The file path must have the format: sdcard/pathToFil
	 * @return the activity xml-tag without the 'tag' (activity tag) parameter 
	 */
	private boolean isTagged(String file) {
		
		String activity = file;
		
		if(!isXmlFile(activity)) {
//			return false;
			throw new IllegalArgumentException(activity +" is not a xml file");
		}
				
		URL url;
		try {
			url = new URL("file:///" +file);
				
		XmlPullParser parser = Xml.newPullParser();
        
		try {
			parser.setInput(url.openStream(), null);
			
			
			int event_type = parser.getEventType();
			boolean done = false;
			String name = null;
			// parser specific:			
			
			while (event_type != XmlResourceParser.END_DOCUMENT && !done){
				
				name = parser.getName();
				
				switch (event_type){
					case XmlResourceParser.START_DOCUMENT:
						
						break;
						
					case XmlResourceParser.START_TAG:
						
						if(name.equalsIgnoreCase("activity")) {
							String actTag = parser.getAttributeValue(null, "tag");
							if(actTag == null || actTag.equalsIgnoreCase("NULL")) 
								return false;
						}
						
						break;
						
					case XmlResourceParser.END_TAG:

						break;
				}
				
				event_type = parser.next();
			}
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			// file does not exists; do not change anything
			Log.d("status", "XmlCreator - file does not exists: " +"file:///"+file);
			e.printStackTrace();
		}
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		
		return true;
	}
	
	
	/**
	 * creates a folder where all xml files will be saved to.
	 */
	private void createFolder() {
		
		File folder = new File(Environment.getExternalStorageDirectory() + "/activityDiary");
//		boolean success = false;
		if(!folder.exists())
		{
//		    success = folder.mkdir();
		    folder.mkdir();
		}         
//		if (!success) 
//		{ 
//		    // Do something on success
//		}
//		else 
//		{
//		    // Do something else on failure 
//		}
		
	}
	
	/**
	 * 
	 * @param file
	 * @return
	 */
	private int getFileNumber(String file) {
		
		// activity34.xml
		
		if(!isXmlFile(file))
			return -1;
		
		String number = file.substring(("activity").length(), file.length()-4); 
		
		int fileNumber;
		try {
			fileNumber = Integer.parseInt(number);
			
			return fileNumber;
			
		}
		catch (NumberFormatException e) {
			Log.d("status", "WRONG format: " +number);
		}
		
		return -1;
	}
	
		
	/**
	 * This method stats, if a given file is a xml file
	 * @param file the full path and file name
	 * @return 
	 */
	private boolean isXmlFile(String file) {
		
		if(file.toLowerCase().endsWith(".xml"))
			return true;
		
		return false;
	}
		
	private long getRawDataEndTime(String file) {
		
		URL url;
		try {
			url = new URL("file:///" +file);
				
		XmlPullParser parser = Xml.newPullParser();
        
		try {
			parser.setInput(url.openStream(), null);
			
			
			int event_type = parser.getEventType();
			boolean done = false;
			String name = null;			
			long endTime = -1;
			while (event_type != XmlResourceParser.END_DOCUMENT && !done){
				
				name = parser.getName();
				
				switch (event_type){
					case XmlResourceParser.START_DOCUMENT:
						
						break;
						
					case XmlResourceParser.START_TAG:
						
						if(name.equalsIgnoreCase("activity")) {
							
							return endTime;
						}
								
						
						if(name.equalsIgnoreCase("data")){
							String timeString = parser.getAttributeValue(null, "time");
							if(timeString != null ) 
								endTime = Long.parseLong(timeString);							
						}						
						
						break;
						
					case XmlResourceParser.END_TAG:

						break;
				}
				
				event_type = parser.next();
			}
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			// file does not exists; do not change anything
			Log.d("status", "XmlCreator - file does not exists: " +"file:///"+file);
			e.printStackTrace();
		}
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		
		return -1;
	}
}
