package de.Android_Seminar.fileTransmitter;


import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import android.app.Service;
import android.content.Intent;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.IBinder;
import android.util.Log;
import android.util.Xml;

/**
 * This class will transmit a file to a server
 * @author jonas
 *
 */
public class FileTransmitter extends Service implements Runnable {
	
	/** server address of the TCP connection **/
//	private final String serverAdress = "http://192.168.178.20/android-page/android/adding_data.php";		
	private final String serverAdress = "http://seminar.theorie-einfach.de/adding_data.php";
	
	/** port of the TCP connection **/
	private final int port = 3306;
	
	/** the file which should be transmitted **/
	private String file;
	private String tmpFile;
	
	/** the values that will be added to the database **/
	private List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(10);
	
	/** the tag of the activity that will be transmitted **/
	private String activityTag;
	
	/** the id of an activity. this id should be retrieved by the database **/
	private int activityID;
	
	/** the userID of the activity that will be transmitted **/
	private int activityUserID;
	
	/** the start time of the activity that will be transmitted **/
	private long activityStartTime;
	
	/** the end time of the activity that will be transmitted **/
	private long activityEndTime;
	
	/** an instance for a {@ FileTransmitter} thread **/
	private Thread thisThread;
	
	/** states if a file is transmitted at the moment **/
	private boolean isTransmitting;
	
	/**
	 * 
	 * @param file the file, which should be transmitted
	 */
	public FileTransmitter() {
		
		Log.d("methodStack", "FileTransmitter -  FileTransmitter(..)");
	}
	
	@Override
	public void onCreate() {
		Log.d("methodStack", "FileTransmitter -  onCreate(..)");
	}
	
	@Override
	public void onDestroy() {
		Log.d("methodStack", "FileTransmitter -  onDestroy(..)");
	}
	
	
	/**
	 * run method of the thread
	 */
	public void run() {
		
		Log.d("methodStack", "FileTransmitter -  run()");
		isTransmitting = true;
		transmitFile();
		isTransmitting = false;
	}
	
	/**
	 * 
	 * @param File the file name of the xml file that should be transmitted.
	 * This file name must consist only of the file's real name, not of it's path 
	 */
	public void transmitFile(String file) {
		
		Log.d("methodStack", "FileTransmitter -  transmitFile(String file)");
		
		tmpFile = file;
		file = Environment.getExternalStorageDirectory() + "/activityDiary/" +file;
		this.file = file;	
		
		thisThread = new Thread(this);
		thisThread.start();
	}
	
	/**
	 * 
	 * @return the file that is transmitted at the moment, or null
	 * if no transmission is taking place.
	 */
	public String getTransmittingFile() {
		
		if(isTransmitting) {
			return this.tmpFile;
		}
		
		return null;
	}
	
	
	private void transmitFile() {
		
		Log.d("methodStack", "FileTransmitter -  transmitFile()");
		
		initActivityProperties();	
		sendActivity();
		
		parseDataSets();
		
		
		File deleteFile = new File(file);		
		deleteFile.delete();	
	}
	
	private void sendActivity() {
		
		Log.d("methodStack", "FileTransmitter -  sendActivity()");

		nameValuePairs.clear();
		nameValuePairs.add(new BasicNameValuePair("user_id", Integer.toString(activityUserID)));
		nameValuePairs.add(new BasicNameValuePair("activity", activityTag));
		Timestamp sTime = new Timestamp(activityStartTime);
		nameValuePairs.add(new BasicNameValuePair("start_time", sTime.toString()));
		Timestamp eTime = new Timestamp(activityEndTime);
		nameValuePairs.add(new BasicNameValuePair("end_time", eTime.toString()));
		nameValuePairs.add(new BasicNameValuePair("isActivity", "TRUE"));
		
		try{
		        HttpClient httpclient = new DefaultHttpClient();
		        HttpPost httppost = new HttpPost(serverAdress);     		        
		        
		        httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs));
		        HttpResponse response = httpclient.execute(httppost);
		        
		        HttpEntity entity = response.getEntity();
		        InputStream is = entity.getContent();
		    
		        
		        String rString = convertStreamToString(is);		        
		        
		    	try {
		    		activityID = Integer.parseInt(rString);
		    	}
		        catch (NumberFormatException e){
		        	Log.d("status", "ERROR - " +e);
		        }
		        
		} catch(Exception e) {
		        Log.d("status", "Error in http connection "+e.toString());
		}
	}
	
	private String convertStreamToString(InputStream is) throws IOException {
		
		if (is != null) {
			Writer writer = new StringWriter();
			
			char[] buffer = new char[1024];
			try {
				Reader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
				int n;
				while ((n = reader.read(buffer)) != -1) {
					writer.write(buffer, 0, n);
				}
			}
			finally {
				is.close();
			}
			return writer.toString();
		}
		else { 
			return "";
		}
		
	}
	
	private void parseDataSets() {
		
		URL url;
		int dataSetCount = 0;
		
		try {
			url = new URL("file:///" +file);
				
		XmlPullParser parser = Xml.newPullParser();
        
		try {
			parser.setInput(url.openStream(), null);
			
			
			int event_type = parser.getEventType();
			boolean done = false;
			String name = null;
			
			// parser specific:			
			
			while (event_type != XmlResourceParser.END_DOCUMENT && !done){
				
				name = parser.getName();
				
				
				if(event_type == XmlResourceParser.START_TAG) {
					if(name.equalsIgnoreCase("data")) {
						
						dataSetCount++;
						
						nameValuePairs.clear();
						nameValuePairs.add(new BasicNameValuePair("isActivity", "FALSE"));
						nameValuePairs.add(new BasicNameValuePair("activity_id", Integer.toString(activityID)));
													
						// sensorType
						String lSensor = parser.getAttributeValue(null, "sensor");
						if(lSensor == null)
							nameValuePairs.add(new BasicNameValuePair("sensorType", "NULL"));
						else
							nameValuePairs.add(new BasicNameValuePair("sensorType", lSensor));
						
						// time
						String lTime = parser.getAttributeValue(null, "time");
						long time;
						if(lTime == null)
							time = 0L;
						else 
							time = Long.parseLong(lTime);
						Timestamp ts = new Timestamp(time);
						nameValuePairs.add(new BasicNameValuePair("time", ts.toString()));
						
						// valueAmount
						String lValueAmount = parser.getAttributeValue(null, "valueAmount");
						if(lValueAmount == null)
							nameValuePairs.add(new BasicNameValuePair("amount", "0"));
						else
							nameValuePairs.add(new BasicNameValuePair("amount", lValueAmount));
						
						
						// values v1-v3
						for(int i=1; i<= 3; i++) {
							String lValue = parser.getAttributeValue(null, "v"+i);
							if(lValue == null)
								nameValuePairs.add(new BasicNameValuePair("value"+i, "NULL"));
							else
								nameValuePairs.add(new BasicNameValuePair("value"+i, lValue));								
						}			
													
						// adjust gps data:
						nameValuePairs.add(new BasicNameValuePair("longitude", "NULL"));
						nameValuePairs.add(new BasicNameValuePair("latitude", "NULL"));
						nameValuePairs.add(new BasicNameValuePair("altitude", "NULL"));
						
						sendData();
						Log.d("status", "Sending record " +dataSetCount +" to the server");
					}			
				}
				
				event_type = parser.next();
				
			}
			
			
			Log.d("status", "Sending HERE");
			Log.d("status", "Sending ALL " +dataSetCount +" data sets to the server");	
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			// file does not exists; do not change anything
			Log.d("status", "FileTransmitter - file does not exists: " +"file:///"+file);
			e.printStackTrace();
		}
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		
		Log.d("status", "Sending HERE");
		Log.d("status", "Sending " +dataSetCount +" data sets to the server");
	}
	
	private void initActivityProperties() {
		
		URL url;
		try {
			url = new URL("file:///" +file);
				
		XmlPullParser parser = Xml.newPullParser();
        
		try {
			parser.setInput(url.openStream(), null);
			
			
			int event_type = parser.getEventType();
			boolean done = false;
			String name = null;
			// parser specific:			
			
			while (event_type != XmlResourceParser.END_DOCUMENT && !done){
				
				name = parser.getName();
				
				switch (event_type){
				
					case XmlResourceParser.START_TAG:
						
						if(name.equalsIgnoreCase("activity")) {
							
							// try to get the properties:
							String lTag = parser.getAttributeValue(null, "tag");
							if(lTag == null)
								lTag = "NULL";
							activityTag = lTag;
							
							String lUserId = parser.getAttributeValue(null, "username");
							if(lUserId == null)
								lUserId = "NULL";
							activityUserID = Integer.parseInt(lUserId);
							
							String lstartTime = parser.getAttributeValue(null, "startTime");
							if(lstartTime == null)
								lstartTime = "0";
							activityStartTime = Long.parseLong(lstartTime);
							
							String lendTime = parser.getAttributeValue(null, "endTime");
							if(lendTime == null)
								lendTime = "0";
							activityEndTime = Long.parseLong(lendTime);
							
							return;
						}
						
						break;
				}
				
				event_type = parser.next();
			}
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();			
		} catch (IOException e) {
			// file does not exists; do not change anything
			Log.d("status", "FileTransmitter - initActivityProperties - file does not exists: " +"file:///"+file);
			e.printStackTrace();
		}
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		
	}
	
	
	private void sendData() {
		
		Log.d("methodStack", "FileTransmitter -  sendData()");

		try{
	        HttpClient httpclient = new DefaultHttpClient();
	        HttpPost httppost = new HttpPost(serverAdress);     		        
	        
	        httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs));
	        HttpResponse response = httpclient.execute(httppost);
	        
	        response.getEntity();
//	        InputStream is = entity.getContent();
	        
		} catch(Exception e) {
		        Log.d("status", "Error in http connection "+e.toString());
		}
	
	}
	
	@Override
	public IBinder onBind(Intent intent) {

		return null;
	}	
	
}
