package de.Android_Seminar.backend.sensors;

import android.hardware.SensorManager;
import de.Android_Seminar.backend.SampleRate;
import de.Android_Seminar.backend.SensorType;
import de.Android_Seminar.backend.impl.SensorDataRecorder;

public class Compass extends SensorDataRecorder {

	public Compass(SensorManager manager, SampleRate sampleRate, int bufferSize) {
		super(manager, sampleRate, bufferSize);
	}

	@Override
	protected void initSensorParameters() {
		
		SENSOR_VALUE_NUMBER = 3;
		sensorType = SensorType.COMPASS;
	}

	@Override
	protected double getMaxValue() {

		return 60.0;
	}

	@Override
	protected double getMinValue() {

		return 30.0;
	}

}
