package de.Android_Seminar.backend.impl;

import android.util.Log;
import de.Android_Seminar.backend.SensorController;
import de.Android_Seminar.backend.SensorData;
import de.Android_Seminar.backend.SensorType;

public class TestClass extends Thread {

	
	SensorController sensCon;
	
	public TestClass(SensorController c) {
		
		sensCon = c;
				
		// activate sensors
		sensCon.activateSensor(SensorType.ACCELEROMETER);
		sensCon.activateSensor(SensorType.COMPASS);
		sensCon.activateSensor(SensorType.TEMPERATURE);
		sensCon.activateSensor(SensorType.ORIENTATION);
		
	}
	
	public void run() {
		
		while(true) {
			
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			
			SensorData accData = sensCon.getCurrentData(SensorType.ACCELEROMETER);
			SensorData oriData = sensCon.getCurrentData(SensorType.ORIENTATION);
			SensorData magData = sensCon.getCurrentData(SensorType.COMPASS);
			SensorData tempData = sensCon.getCurrentData(SensorType.TEMPERATURE);
//			
			if(accData!= null)
				Log.d("status", "ACC - x: " +accData.getValues()[0] +", y: "  +accData.getValues()[1] +", z: "  +accData.getValues()[2]);				
			
//			if(magData!= null) 
//				Log.d("status", "MAG - x: " +magData.getValues()[0] +", y: "  +magData.getValues()[1] +", z: "  +magData.getValues()[2]);
//			
			
//			if(oriData!= null) 
//				Log.d("status", "ORI - x: " +oriData.getValues()[0] +", y: "  +oriData.getValues()[1] +", z: "  +oriData.getValues()[2]);
//			
//			if(tempData!= null ) 
//				Log.d("status", "TEMP - Degrees: " +tempData.getValues()[0]);
		}
		
	}
	
	
	
}
