package de.Android_Seminar.backend.impl;

import android.hardware.Sensor;
import de.Android_Seminar.backend.SensorType;

/**
 * This class maps android's sensors to {@link SensorType}
 * and vice versa. If there is no corresponding mapping
 * for a sensor, null is returned.
 * @author jonas
 *
 */
public class SensorMapping {

	/**
	 * 
	 * @param sensor a android's sensor
	 * @return the {@link SensorType} for the given
	 * android sensor, or null if there is no such corresponding sensor
	 */
	public static SensorType getSensorType(Sensor sensor) {
		
		SensorType type = null;
		
		switch(sensor.getType()){
		case Sensor.TYPE_ACCELEROMETER:
			type = SensorType.ACCELEROMETER;
			break;
		case Sensor.TYPE_GYROSCOPE:
			type = SensorType.GYROSKOPE;
			break;
		case Sensor.TYPE_LIGHT:
			type = SensorType.LIGHT_SENSOR;
			break;
		case Sensor.TYPE_MAGNETIC_FIELD:
			type = SensorType.COMPASS;
			break;
		case Sensor.TYPE_ORIENTATION:
			type = SensorType.ORIENTATION;
			break;
		case Sensor.TYPE_PRESSURE:
			type = SensorType.PRESSURE;
			break;
		case Sensor.TYPE_PROXIMITY:
			type = SensorType.PROXIMITY_SENSOR;
			break;
		case Sensor.TYPE_TEMPERATURE:
			type = SensorType.TEMPERATURE;
			break;
			
		}
		
		return type;
	}
	
	/**
	 * 
	 * @param sensor a {@link SensorType} sensor
	 * @return the corresponding android sensor, or -2 if there is no such 
	 * corresponding sensor
	 */
	public static int getAndroidSensor(SensorType sensor) {
		
		
		int lSensorType = 2; 
		
		switch (sensor) {
		case PROXIMITY_SENSOR:
			lSensorType = Sensor.TYPE_PROXIMITY;
			break;
		case COMPASS:
			lSensorType = Sensor.TYPE_MAGNETIC_FIELD;
			break;
		case ACCELEROMETER:
			lSensorType = Sensor.TYPE_ACCELEROMETER;
			break;
		case LIGHT_SENSOR:
			lSensorType = Sensor.TYPE_LIGHT;
			break;
		case AUDIO_SENSOR:
			lSensorType = -2;
			break;
		case GPS_SENSOR:
			lSensorType = -2;
			break;
		case GYROSKOPE:
			lSensorType = Sensor.TYPE_GYROSCOPE;
			break;
		case TEMPERATURE:
			lSensorType = Sensor.TYPE_TEMPERATURE;
			break;
		case ORIENTATION:
			lSensorType = Sensor.TYPE_ORIENTATION;
			break;
		case PRESSURE:
			lSensorType = Sensor.TYPE_PRESSURE;
			break;
		}
		
		
		return lSensorType;
	}
	
}
