package de.Android_Seminar.backend.impl;

import java.sql.Timestamp;
import android.location.Location;
import de.Android_Seminar.backend.SensorData;
import de.Android_Seminar.backend.SensorType;

public class SensorDataImpl implements SensorData{

	/** the values a sensor delivers **/
	private double[] values;
	
	/** the type of the sensor that produces values for this data set **/
	private SensorType sensor;
	
	/** the amount of values stored in this data set **/
	private int length;
	
	/** the time, when the values in the values array have been set up **/
	private Timestamp timeStamp;
	
	/** the location, at which the values in the values array have been set up **/
	private Location location;
	
	/**
	 * standard constructor
	 * 
	 * @param sensor the sensor type
	 * @param length the number of values saved in this data set
	 * @see SensorData#getLength()
	 * @see SensorData#getSensorType()
	 */
	public SensorDataImpl(SensorType sensor, int length) {
		
		this.length = length;
		this.sensor = sensor;
		this.values = new double[length];
		this.timeStamp = new Timestamp(System.currentTimeMillis());
	}
	
	public int getLength() {

		return length;
	}

	public SensorType getSensorType() {

		return sensor;
	}

	public Timestamp getTimeStamp() {

		return timeStamp;
	}

	public double[] getValues() {

		return values;
	}

	public void setValues(double[] newValues, long timestamp) {
		
		if(values.length != newValues.length)
			return;
		
		for(int i=0; i<values.length; i++)
			values[i] = newValues[i];
		
		timeStamp.setTime(timestamp);		
	}
	
	public Location getLocation() {
		
		return location;
	}

	public void setLocation(Location location) {
		
		this.location = location;
	}
	
	public void setTimeStamp(Timestamp timeStamp) {
		
		this.timeStamp = timeStamp;
	}
}
