package de.Android_Seminar.backend.impl;


import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.util.Log;
import de.Android_Seminar.backend.SampleRate;
import de.Android_Seminar.backend.SensorConfiguration;
import de.Android_Seminar.backend.SensorController;
import de.Android_Seminar.backend.SensorData;
import de.Android_Seminar.backend.SensorType;
import de.Android_Seminar.backend.sensors.Accelerometer;
import de.Android_Seminar.backend.sensors.Compass;
import de.Android_Seminar.backend.sensors.Gyroskope;
import de.Android_Seminar.backend.sensors.LightSensor;
import de.Android_Seminar.backend.sensors.OrientationSensor;
import de.Android_Seminar.backend.sensors.PressureSensor;
import de.Android_Seminar.backend.sensors.ProximitySensor;
import de.Android_Seminar.backend.sensors.TemparatureSensor;
import de.Android_Seminar.fileTransmitter.FileTransmitter;
import de.Android_Seminar.xmlCreator.XmlCreator;

public class SensorControllerImpl implements SensorController {

//	/** the tag of the activity which will be recored. Empty tags allowed **/
//	private String currentActivityTag;
	
	/** the active sensors. All this sensors will be used while recording **/
	private ArrayList<SensorDataRecorder> activeSensors = new ArrayList<SensorDataRecorder>();
	
	/** a configuration class that holds some parameters for sensors **/
	private SensorConfiguration sensorConfig;
	
	/** the android's sensor manager **/
	private SensorManager manager;
	
	/** the {@link XmlCreator} that saves the data **/
	private XmlCreator xml;
	
	/** a {@ FileTransmitter} that supplies features for transmitting a file to a server **/
	private FileTransmitter fileTransmitter;
	
	/** main activity **/
	private Activity activity;
	
	/**
	 * standard constructor
	 */
	public SensorControllerImpl(SensorManager manager, Activity activity) {
		
		Log.d("methodStack", "SensorControllerImpl - SensorControllerImpl()");
		
		sensorConfig = new SensorConfigurationImpl();
		this.manager = manager;
		xml = new XmlCreator(this);	
		fileTransmitter = new FileTransmitter();
		this.activity = activity;
		
		// testing: TODO: delete
//		fileTransmitter.transmitFile("activity0.xml");
//		startService(new Intent(this, FileTransmitter.class));
	}
	
	public void activateSensor(SensorType sensor) {
		
		Log.d("methodStack", "SensorControllerImpl - activateSensor(SensorType sensor)");
		
		activateSensor(sensor, 30);
	}
	
	public void activateSensor(SensorType sensor, int bufferSize) {
		
		Log.d("methodStack", "SensorControllerImpl - activateSensor(SensorType sensor, int bufferSize)");
		
		if(bufferSize<1){
			activateSensor(sensor);
			return;
		}
		
		SampleRate rate = sensorConfig.getLastSampleRates().get(sensor);
		if(rate == null)
			rate = SampleRate.NORMAL;
		
		SensorDataRecorder tmpSensor = null;
		
		switch(sensor) {
		case PROXIMITY_SENSOR: 
			tmpSensor = new ProximitySensor(manager, rate, bufferSize); 
			break;
		case COMPASS: 
			tmpSensor = new Compass(manager, rate, bufferSize);
			break;
		case ACCELEROMETER: 
			tmpSensor = new Accelerometer(manager, rate, bufferSize); 
			break;
		case LIGHT_SENSOR: 
			tmpSensor = new LightSensor(manager, rate, bufferSize); 
			break;
		case AUDIO_SENSOR: 
						
			break;
		case GPS_SENSOR: 
							
			break;
		case GYROSKOPE: 
			tmpSensor = new Gyroskope(manager, rate, bufferSize);
			break;
		case TEMPERATURE: 
			tmpSensor = new TemparatureSensor(manager, rate, bufferSize); 
			break;
		case ORIENTATION: 
			tmpSensor = new OrientationSensor(manager, rate, bufferSize);
			break;
		case PRESSURE: 
			tmpSensor = new PressureSensor(manager, rate, bufferSize); 
			break;
		}
		
		
		deactivateSensor(tmpSensor.sensorType);
		activeSensors.add(tmpSensor);
	}

	public void close() {
		
		Log.d("methodStack", "SensorControllerImpl -  close()");
		
		if (xml != null) xml.stopRecording();
		
		for(int i=0; i<activeSensors.size(); i++)
			activeSensors.get(i).deactivateSensor(manager);		
		
	}

	public void deactivateSensor(SensorType sensor) {
		
		Log.d("methodStack", "SensorControllerImpl -  deactivateSensor()");
		
		if(activeSensors.contains(sensor)){
			int i = activeSensors.indexOf(sensor);
			activeSensors.get(i).deactivateSensor(manager);
			activeSensors.remove(i);
		}
	}

	public List<SensorType> getActiveSensors() {
		
//		Log.d("methodStack", "SensorControllerImpl -  getActiveSensors()");
		
		List<SensorType> sensors = new ArrayList<SensorType>(activeSensors.size());
		for(int i=0; i<activeSensors.size(); i++)
			sensors.add(activeSensors.get(i).sensorType);
			
		return sensors;
	}

	public SensorData[] getBufferedData(SensorType sensor, int amount) {
		
//		Log.d("methodStack", "SensorControllerImpl -  getBufferedData(..)");
		
		for(int i=0; i<activeSensors.size(); i++) {
			if(activeSensors.get(i).sensorType == sensor)
				return activeSensors.get(i).getBufferedData(amount);
		}
		
		return null;
	}

	public SensorData getCurrentData(SensorType sensor) {
		
		Log.d("methodStack", "SensorControllerImpl -  getCurrentData(..)");
		
		for(int i=0; i<activeSensors.size(); i++) {
			if(activeSensors.get(i).sensorType == sensor)
				return activeSensors.get(i).getCurrentData();
		}
		return null;
	}

	public int getDeviceSensorNumber() {

		Log.d("methodStack", "SensorControllerImpl -  getDeviceSensorNumber()");
		
		return manager.getSensorList(Sensor.TYPE_ALL).size();
	}

	public List<SensorType> getDeviceSensors() {
		
		Log.d("methodStack", "SensorControllerImpl -  getDeviceSensors()");
		
		List<SensorType> sensors = new ArrayList<SensorType>(manager.getSensorList(Sensor.TYPE_ALL).size());
		
		for(Sensor sensor : (manager.getSensorList(Sensor.TYPE_ALL)) ) {
			SensorType s = SensorMapping.getSensorType(sensor);
			sensors.add(s);
		}
		
		
		
		return sensors;
	}

	public double getMaxValue(SensorType sensor) {
		
		Log.d("methodStack", "SensorControllerImpl -  getMaxValue(..)");
		
		if (activeSensors.contains(sensor)) {
			int i = activeSensors.indexOf(sensor);
			return activeSensors.get(i).getMaxValue();
		}
		return 0;
	}

	public double getMinValue(SensorType sensor) {
		
		Log.d("methodStack", "SensorControllerImpl -  getMinValue(..)");
		
		if (activeSensors.contains(sensor)) {
			int i = activeSensors.indexOf(sensor);
			return activeSensors.get(i).getMinValue();
		}
		return 0;
	}

	public SensorConfiguration getSensorConfiguration() {

		Log.d("methodStack", "SensorControllerImpl -  getSensorConfiguration()");
		
		return sensorConfig;
	}

	public boolean hasSensor(SensorType sensor) {
		
		Log.d("methodStack", "SensorControllerImpl -  hasSensor(..)");
		
		int androidSensor = SensorMapping.getAndroidSensor(sensor);
		int number = manager.getSensorList(androidSensor).size();
		
		if(number > 0)
			return true;
		return false;
	}

	public boolean isRecordin() {		

		Log.d("methodStack", "SensorControllerImpl -  isRecordin()");
		
		return xml.isRecording();
	}

	public boolean sensorIsActive(SensorType sensor) {

		Log.d("methodStack", "SensorControllerImpl -  sensorIsActive(..)");
		
		for(int i=0; i<activeSensors.size(); i++) {
			if(activeSensors.get(i).sensorType == sensor)
				return true;
		}
		
		return false;
	}

	public void startRecording(String tag, String file) {
		
		Log.d("methodStack", "SensorControllerImpl -  startRecording(..)");
				
		xml.startRecording();
	}

	public void stopRecording() {
		
		Log.d("methodStack", "SensorControllerImpl -  stopRecording()");
		
		if(xml == null)
			return;
		
		Log.d("status", "STOP  recording");
		
		xml.stopRecording();
		
	}
	
	public XmlCreator getXmlCreator() {
		
		return this.xml;
	}
	
	public FileTransmitter getFileTransmitter() {
		
		return fileTransmitter;
	}
}
