package de.Android_Seminar;

import java.text.DateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;

import de.Android_Seminar.backend.SensorController;
import de.Android_Seminar.backend.SensorType;
import de.Android_Seminar.backend.impl.SensorControllerImpl;
import de.Android_Seminar.xmlCreator.XmlCreator;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.AvoidXfermode;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;
import android.view.Window;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.TimePicker;


/**
 * @author Kai
 *
 * This Class provides us the tagging and the tagging view
 */
public class Tagging extends Activity {
	
	
	private SensorController sensorController;
	private XmlCreator xmlCreator;
	private boolean record = false;
	
	
	//Tagging Screen
	private Spinner activitySpinner;
	private RadioGroup radioGroup;
	private TimePicker timePicker;
	private DatePicker datePicker;
	
	private AlertDialog.Builder start_builder;
	private AlertDialog start_time_dialog;
	private View start_time_view;
	
	private AlertDialog.Builder end_builder;
	private AlertDialog end_time_dialog;
	private View end_time_view;

	
	private static Date startTime;
	private static Date endTime;
	

    /**
     * Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        Log.d("Status_Dominik", "Tagging onCreate");
        requestWindowFeature(Window.FEATURE_NO_TITLE);
       
        // prevent screen  
        setRequestedOrientation(1); 
        
        /*
         * set up sensor manager
         */   
        this.sensorController = Sensor_Logging_for_Mobility.sensorController;
        
        this.xmlCreator = sensorController.getXmlCreator();
        
        
        taggingScreen();

    }
    
    /**
    *
    *  Called when the activity will be Paused.
    */
	@Override
	protected void onPause(){
		super.onPause();
		Log.d("Status_Dominik", "Tagging onPause");
		this.startTime = null;
		this.endTime = null;
		
	}
	
	/**
    *
    *  Called when the activity will be Resumed.
    */
	@Override
	protected void onResume(){
		super.onResume();
		Log.d("Status_Dominik", "Tagging onResume");
			
	}

	/**
    *
    *  Called when the activity will be Stopped.
    */
	@Override
    protected void onStop(){
		super.onStop();
		Log.d("Status_Dominik", "Tagging onStop");
		
	}
	
	/**
	 * This method built us a dialog for the start time
	 */
	private void setUpDialogStart(){
		Context mContext = this;
        LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(LAYOUT_INFLATER_SERVICE);
        start_time_view = inflater.inflate(R.layout.time, (ViewGroup) findViewById(R.id.time_linear));
        start_builder = new AlertDialog.Builder(mContext);
        start_builder.setView(start_time_view);
        
        start_builder.setIcon(R.drawable.icon);
        start_builder.setTitle(R.string.chooseTime);
        
        start_builder.setPositiveButton(R.string.choose, new DialogInterface.OnClickListener() {
        	public void onClick(DialogInterface dialog, int id) {
        		
            	datePicker = (DatePicker) start_time_dialog.findViewById(R.id.date_picker);
            	timePicker = (TimePicker) start_time_dialog.findViewById(R.id.time_picker);
            	
            	startTime = new Date(datePicker.getYear() - 1900, datePicker.getMonth(), datePicker.getDayOfMonth(), timePicker.getCurrentHour(), timePicker.getCurrentMinute());
            	
        		dialog.cancel();
        	}
        });
        
        
        start_time_dialog = start_builder.create();
	}
	
	/**
	 * This method built us a dialog for end time
	 */
	private void setUpDialogEnd(){
		Context mContext = this;
        LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(LAYOUT_INFLATER_SERVICE);
        end_time_view = inflater.inflate(R.layout.time, (ViewGroup) findViewById(R.id.time_linear));
        end_builder = new AlertDialog.Builder(mContext);
        end_builder.setView(end_time_view);
        
        end_builder.setIcon(R.drawable.icon);
        end_builder.setTitle(R.string.chooseTime);
        
        end_builder.setPositiveButton(R.string.choose, new DialogInterface.OnClickListener() {
        	public void onClick(DialogInterface dialog, int id) {
        		
            	datePicker = (DatePicker) end_time_dialog.findViewById(R.id.date_picker);
            	timePicker = (TimePicker) end_time_dialog.findViewById(R.id.time_picker);
            	
            	endTime = new Date(datePicker.getYear() - 1900, datePicker.getMonth(), datePicker.getDayOfMonth(), timePicker.getCurrentHour(), timePicker.getCurrentMinute());
            	
        		dialog.cancel();
        	}
        });
        
        
        end_time_dialog = end_builder.create();
	}
        
    
    /**
     * Create the Tagging Screen with Listener for every Button
     */
    private void taggingScreen(){
    	
        setUpDialogStart();
        setUpDialogEnd();
    	
    	setContentView(R.layout.tagging);
    	
    	
    	Button button = (Button) findViewById(R.id.start_time_button);
    	button.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
        		start_time_dialog.show();
        	}
        });
    	
    	button = (Button) findViewById(R.id.end_time_button);
    	button.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
        		end_time_dialog.show();
        	}
        });
    	
    	
    	this.activitySpinner = (Spinner)findViewById(R.id.spinner_activities);

    	String[] items =  new String[] {getString(R.string.act_run), getString(R.string.act_car_drive),getString(R.string.act_bicycle), getString(R.string.act_1), getString(R.string.act_2), getString(R.string.act_3), getString(R.string.act_4), getString(R.string.act_5), getString(R.string.act_6), getString(R.string.act_7), getString(R.string.act_8), getString(R.string.act_9), getString(R.string.act_10), getString(R.string.act_11), getString(R.string.act_12)};
    	ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_dropdown_item, items);
    	
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	this.activitySpinner.setAdapter(adapter);
    	
    	
    	LinearLayout linear = (LinearLayout)this.findViewById(R.id.files);
    	
    	LinkedList<String> alreadyTagged = xmlCreator.getXmlActivities();
    	LinkedList<String> notTagged = xmlCreator.getXmlRawData();
    	
    	String aT = (alreadyTagged == null ? "NULL" : alreadyTagged.toString());
    	String nT = (notTagged == null ? "NULL" : notTagged.toString());
    	
    	Log.d("Status_Dominik", "Tagging " + aT+ " " + nT);
    	
    	this.radioGroup = new RadioGroup(this);
    	RadioButton radio;
    	
    	Date start;
    	Date stop;	
    	
    	if (notTagged != null){
	    	for(String file: notTagged) {
	    		start = new java.util.Date(this.xmlCreator.getActivityStartTime(file));
	    		stop = new java.util.Date(this.xmlCreator.getActivityStartTime(file));
	    		
	    		radio = new RadioButton(this);
	    		
	    		radio.setText(dateFormat(start) + "  -  " + dateFormat(stop));
	    		radio.setTag(file);
	    		
	    		radioGroup.addView(radio);
	    		
	    	}
    	}
    	
    	
    	linear.addView(radioGroup);
    	
    	Button saveButton = new Button(this);
    	saveButton.setText(getString(R.string.saveButton));
    	saveButton.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
            	Log.d("Status_Dominik", "Tagging Click button saveButton");
            	
            	
            	tagActivity();
            	
            	Log.d("Status_Dominik", "Tagging Reload after save");
            	taggingScreen();
        	}
        });
    	
    	linear.addView(saveButton);
    	
    	
    	Button deleteButton = new Button(this);
    	deleteButton.setText(getString(R.string.deleteButton));
    	deleteButton.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
            	Log.d("Status_Dominik", "Tagging Click button deleteButton");
            	
            	RadioButton radio = (RadioButton) findViewById(radioGroup.getCheckedRadioButtonId());
            	if (radio == null) return;
            	xmlCreator.deleteXmlFile((String)radio.getTag());
            	
            	Log.d("Status_Dominik", "Tagging Reload after delete");
            	taggingScreen();
        	}
        });
    	
    	linear.addView(deleteButton);
    	
    	
    }
    
    
    /**
     * This tags our activity in a time range
     */
    private void tagActivity() {
    	RadioButton radioButton = (RadioButton)findViewById(radioGroup.getCheckedRadioButtonId());
    	
    	if(radioButton == null) return;
    	
    	this.activitySpinner = (Spinner) findViewById(R.id.spinner_activities);
    	
    	Log.d("Status_Dominik","Tagging radioButton != NULL at tagActivity");

    	if(startTime == null || endTime == null) return; //TODO Fehlermeldung werfen
    	
    	Log.d("Status_Dominik","Tagging time != NULL at tagActivity");
    	
		xmlCreator.tagActivity((String)activitySpinner.getSelectedItem(), (String)radioButton.getTag(), startTime.getTime(), endTime.getTime());
    	
		
		//Debug
		LinkedList<String> alreadyTagged = xmlCreator.getXmlActivities();
		
		Log.d("Status_Dominik","Tagging Already Tagged:" + alreadyTagged.size());
		
    	return;
    }

    /**
     * This formats us the time in a readable format 
     * @param date
     * @return String readable date format
     */
	private String dateFormat(Date date) {
		//return date.getDay() + "." + (date.getMonth() + 1) + "." + (date.getYear()+1900) + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
		
		DateFormat df = DateFormat.getDateTimeInstance( DateFormat.SHORT, DateFormat.SHORT );
		
		return df.format(date);
	}    
    
}