package de.Android_Seminar;

import java.util.EventListener;
import java.util.List;
import de.Android_Seminar.backend.SensorController;
import de.Android_Seminar.backend.SensorType;
import de.Android_Seminar.backend.impl.SensorControllerImpl;
import de.Android_Seminar.xmlCreator.XmlCreator;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;


/**
 * @author Kai
 *
 * This class is the main Activity and print the diagram and provides us with help of the menu key the other activities
 */
public class Sensor_Logging_for_Mobility extends Activity implements EventListener {
	
	private AlertDialog.Builder builder;
	private AlertDialog activity_dialog;
	private View activity_view;
	
	public static SensorController sensorController;
	private XmlCreator xmlCreator;
	
	private boolean record = false;
	
	
	//Home Screen
	private Graphics graphics;
	private Button propertiesButton;
	private Button taggingButton;
	private Button recordButton;
	
	//Tagging Screen
	private Spinner activitySpinner;

	//Properties
	private SensorType[] sensorTyps = new SensorType[] {SensorType.PROXIMITY_SENSOR, SensorType.COMPASS, SensorType.ACCELEROMETER, SensorType.LIGHT_SENSOR, SensorType.AUDIO_SENSOR, SensorType.GPS_SENSOR, SensorType.GYROSKOPE};
	private boolean[] checked = new boolean[] {false, false, false, false, false, false, false};
	private boolean[] paint = new boolean[] {false, false, false , false, false, false, false};
	

    /**
     * Called when the activity is first created.
     * 
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        Log.d("Status_Dominik", "Main onCreate");
        requestWindowFeature(Window.FEATURE_NO_TITLE);
       
        restorePreferences();
                
        // prevent screen  
        setRequestedOrientation(1); 
        
        /*
         * set up sensor manager
         */
        SensorManager manager = (SensorManager)getSystemService(Context.SENSOR_SERVICE);   
        Sensor_Logging_for_Mobility.sensorController = new SensorControllerImpl(manager, this);
        this.xmlCreator = Sensor_Logging_for_Mobility.sensorController.getXmlCreator();
        
        this.graphics = new Graphics(this,Sensor_Logging_for_Mobility.sensorController,100,100);
        
        
        List<SensorType> availableSensor = Sensor_Logging_for_Mobility.sensorController.getDeviceSensors();
        
        // We need an Editor object to make preference changes.
		// All objects are from android.context.Context
        SharedPreferences settings = getSharedPreferences("logging_prefs", 0);
		SharedPreferences.Editor editor = settings.edit();
		for(int i=0; i<sensorTyps.length; i++) {
			if(availableSensor.contains(sensorTyps[i]))
				editor.putString("available-" + i, sensorTyps[i].toString());
			}
		
		// Commit the edits!
		editor.commit();
    	
		setUpDialog();
        
        homeScreen();
        
        final LinearLayout linear = (LinearLayout)findViewById(R.id.imageView);
        ViewTreeObserver vto = linear.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new OnGlobalLayoutListener() {
            public void onGlobalLayout() {
            	graphics.setDimension(linear.getHeight(), linear.getWidth());
            	
            	graphics.diagramm();
                
                linear.getViewTreeObserver().removeGlobalOnLayoutListener(this);
            }
        });
        
    }
    
    /**
     * This restores our Preferences with help of SharedPreferneces
     */
	private void restorePreferences() {
		 // Restore preferences
        SharedPreferences settings = getSharedPreferences("logging_prefs", 0);
        for(int i=0; i<sensorTyps.length; i++) {
        	checked[i] = settings.getBoolean(sensorTyps[i].toString() + "-checked", false);
        	paint[i] = settings.getBoolean(sensorTyps[i].toString() + "-paint", false);
        }		
	}
	
   /**
    *
    *  Called when the activity will be Paused.
    */
	@Override
	protected void onPause(){
		super.onPause();
		Log.d("Status_Dominik", "Main onPause");
		this.graphics.setStop();
		
	}
	
   /**
    *
    *  Called when the activity will be Resumed.
    */
	@Override
	protected void onResume(){
		super.onResume();
		
		Log.d("Status_Dominik", "Main onResume start Graphic Thread");
		
		restorePreferences();
		
    	LinearLayout linear = (LinearLayout)findViewById(R.id.imageView);
    	removeImageView();  
    	linear.addView(this.graphics.getImageView());
		
    	List<SensorType> activeSensors = sensorController.getActiveSensors();
    	
    	Log.d("Status_Dominik","ActiveSensors: " + activeSensors.toString());
		
		for(int i = 0; i < sensorTyps.length; i++) {
			
			if(activeSensors == null) {
				if(checked[i]) sensorController.activateSensor(sensorTyps[i]);
				continue;
			}
			
			if(checked[i] && !activeSensors.contains(sensorTyps[i]))
				sensorController.activateSensor(sensorTyps[i]);
			if(!checked[i] && activeSensors.contains(sensorTyps[i]))
				sensorController.deactivateSensor(sensorTyps[i]);
			
		}
		
		if(this.record){
			this.graphics.setStart();
    		Thread t = new Thread(graphics);
    		t.start();
    		
			
		}
		
		Log.d("Status_Dominik", "Main onResume");
	}

   /**
    *
    *  Called when the activity will be Stopped.
    */
	@Override
    protected void onStop(){
		super.onStop();
		Log.d("Status_Dominik", "Main onStop");
		
	}
	
	
	/**
	 * This set up a dialog. With this dialog a user can choose his activity
	 */
	private void setUpDialog(){
		Context mContext = this;
        LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(LAYOUT_INFLATER_SERVICE);
        activity_view = inflater.inflate(R.layout.activity, (ViewGroup) findViewById(R.id.activity_linear));
        builder = new AlertDialog.Builder(mContext);
        builder.setView(activity_view);
        
        builder.setIcon(R.drawable.icon);
        builder.setTitle(R.string.choose_activity);
        
        builder.setPositiveButton(R.string.choose, new DialogInterface.OnClickListener() {
        	public void onClick(DialogInterface dialog, int id) {
        		
        		RadioGroup radiogroup = (RadioGroup) activity_dialog.findViewById(R.id.activity_group);
        		
        		RadioButton aktiv = (RadioButton)activity_dialog.findViewById(radiogroup.getCheckedRadioButtonId());
        		
        		String tag = (String)aktiv.getTag();
        		
        		if (tag.equals(getText(R.string.act_none))) {
        			xmlCreator.startRecording();
        		} else {
        			xmlCreator.startRecording(tag);
        		}
        		
        		graphics.setStart();
        		Thread t = new Thread(graphics);
        		t.start();
        		dialog.cancel();
        	}
        });
        builder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
        	public void onClick(DialogInterface dialog, int id) {
        		record = !record;
        		
        		Log.d("Status_Dominik", "Main startRecord");
        		
        		dialog.cancel();
        	}
        });
        
        
        activity_dialog = builder.create();
	}
    
    /**
     * Create the Home Screen with Listener for every Button
     */
    private void homeScreen(){
    	
    	Log.d("Status_Dominik", "Main homeScreen()");
    	
    	//Set Layout
    	setContentView(R.layout.main);
    	
    }
        
    
    
    /**
     * This method catch the KeyEvent. We change some key events 
     */
    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
    	if ((keyCode == KeyEvent.KEYCODE_BACK)) {
    		Log.d("Status_Dominik", "Main Click searchKey");
    		this.graphics.setStop();
    		sensorController.close();
    		Log.d("Status-Dominik","Main Stop Application");
    		this.finish();
    	}
    	
    	if ((keyCode == KeyEvent.KEYCODE_MENU)) {
    		
    		return false;
    		
//    		loadProperties();
//    		Log.d("Status_Dominik", "Main Click menuKey");
    	}
    	
    	if((keyCode == KeyEvent.KEYCODE_SEARCH)) {
    		loadTagging();
    		Log.d("Status_Dominik", "Main Click searchKey");
    		
    	}
    	return true;
    }
    
    /**
     * This starts our properties view
     */
    public void loadProperties() {
    	Log.d("Status_Dominik", "Main loadProperties()");
    	startActivity(new Intent(Sensor_Logging_for_Mobility.this, Properties.class));
    }
    
    /**
     * This starts our tagging view
     */
    public void loadTagging() {
    	Log.d("Status_Dominik", "Main loadTagging()");
    	startActivity(new Intent(Sensor_Logging_for_Mobility.this, Tagging.class));
    }
    
    /**
     * This starts our sending view
     */
    public void loadSending() {
    	Log.d("Status_Dominik", "Main loadSending()");
    	startActivity(new Intent(Sensor_Logging_for_Mobility.this, Sending.class));
    }
    
    /**
     * Remove the parent of the ImageView, so that we are able to set a new one
     */
    private void removeImageView(){
    	LinearLayout i = (LinearLayout)this.graphics.getImageView().getParent();
    	
    	if(i == null) return;
    	
    	Log.d("Status_Dominik", "Main Remove Parent from ImageView");
    	i.removeView(this.graphics.getImageView());
    	
    	return;
    }
    
    /**
     * This gives us all sensors types
     * @return SensorType[]
     */
    public SensorType[] getSensorTyps() {
    	return this.sensorTyps;
    }
    
    /**
     * This gives us all checked sensors
     * @return boolean[]
     */
    public boolean[] getSensorsChecked() {
    	return this.checked;
    }
    
    /**
     * This give us all Sensors which should be painted
     * @return boolean[]
     */
    public boolean[] getSensorsPaint() {
    	return this.paint;
    }
    
    /**
     * This we need for the Menu. It is called by the first time we start the menu
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu, menu);
        return true;
    }
    
    /**
     * This is called every time we enter the menu
     */
    @Override
    public boolean onPreparePanel(int i, View view, Menu menu) {
    	
    	
    	MenuItem item = (MenuItem) menu.findItem(R.id.menu_Record);
    	
    	item.setTitle(record ?getString(R.string.stop_button):getString(R.string.record_button));
    	
    	return true;
    }
    
    /**
     * This is execute if one Item will be selected
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        switch (item.getItemId()) {
        case R.id.menu_properties:
            loadProperties();
            return true;
        case R.id.menu_Record:
        	record = !record;
    		
    		
    		if(record) {
    			
        		activity_dialog.show();
        		
        		
    		} else {
    			Log.d("Status_Dominik", "Main StopRecord");
    			xmlCreator.stopRecording();
    			graphics.setStop();
    			
    		}
            return true;
        case R.id.menu_tagging:
            loadTagging();
            return true;
        case R.id.menu_sending:
        	loadSending();
        	return true;
        default:
            return super.onOptionsItemSelected(item);
        }
    }


    
    
}