package de.Android_Seminar;

import java.text.DateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;

import de.Android_Seminar.backend.SensorController;
import de.Android_Seminar.backend.SensorType;
import de.Android_Seminar.backend.impl.SensorControllerImpl;
import de.Android_Seminar.fileTransmitter.FileTransmitter;
import de.Android_Seminar.xmlCreator.XmlCreator;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;
import android.view.Window;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;


/**
 * @author Kai
 *
 * This class provide us the sending view
 */
public class Sending extends Activity implements EventListener {
		
	public static SensorController sensorController;
	private XmlCreator xmlCreator;
	private FileTransmitter fileTransmitter;
	
	private RadioGroup radioGroup;
	

    /**
     * Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        Log.d("Status_Dominik", "Sending onCreate");
        requestWindowFeature(Window.FEATURE_NO_TITLE);
       
        // prevent screen  
        setRequestedOrientation(1); 
        
        /*
         * set up sensor manager
         */
        Sending.sensorController = Sensor_Logging_for_Mobility.sensorController;
        this.xmlCreator = Sending.sensorController.getXmlCreator();
        this.fileTransmitter = sensorController.getFileTransmitter();
        
        
        sendingScreen();
        
    }
    
    
   /**
    *
    *  Called when the activity will be Paused.
    */
	@Override
	protected void onPause(){
		super.onPause();
		Log.d("Status_Dominik", "Sending onPause");
		
	}
	
   /**
    *
    *  Called when the activity will be Resumed.
    */
	@Override
	protected void onResume(){
		super.onResume();
		
		Log.d("Status_Dominik", "Sending onResume");
		
		
	}

   /**
    *
    *  Called when the activity will be Stopped.
    */
	@Override
    protected void onStop(){
		super.onStop();
		Log.d("Status_Dominik", "Main onStop");
	}
	
	

    
    /**
     * Create the sending Screen with Listener for every Button
     */
    private void sendingScreen(){
    	
    	Log.d("Status_Dominik", "Sending sendingScreen()");
    	
    	//Set Layout
    	setContentView(R.layout.sending);
    	
    	
    	LinearLayout linear = (LinearLayout)this.findViewById(R.id.linear_sending);
    	
    	LinkedList<String> alreadyTagged = xmlCreator.getXmlActivities();
    	LinkedList<String> notTagged = xmlCreator.getXmlRawData();
    	
    	String aT = (alreadyTagged == null ? "NULL" : alreadyTagged.toString());
    	String nT = (notTagged == null ? "NULL" : notTagged.toString());
    	
    	Log.d("Status_Dominik", "Sending " + aT+ " " + nT);
    	
    	this.radioGroup = new RadioGroup(this);
    	RadioButton radio;
    	
    	Date start;
    	Date stop;
    	
    	
    	if (alreadyTagged != null){
	    	for(String file: alreadyTagged) {
	    		start = new java.util.Date(this.xmlCreator.getActivityStartTime(file));
	    		
	    		radio = new RadioButton(this);
	    		
	    		radio.setText(this.xmlCreator.getActivityName(file) + " " + dateFormat(start));
	    		radio.setTag(file);
	    		
	    		radioGroup.addView(radio);
	    		
	    	}
    	}
    	
    	
    	if (notTagged != null){
	    	for(String file: notTagged) {
	    		start = new java.util.Date(this.xmlCreator.getActivityStartTime(file));
	    		stop = new java.util.Date(this.xmlCreator.getActivityStartTime(file));
	    		
	    		radio = new RadioButton(this);
	    		
	    		radio.setText(dateFormat(start) + "  -  " + dateFormat(stop));
	    		radio.setTag(file);
	    		
	    		radioGroup.addView(radio);
	    		
	    	}
    	}
    	
    	linear.addView(radioGroup);
    	
    	Button sendButton = new Button(this);
    	sendButton.setText(getString(R.string.sending_button));
    	sendButton.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
            	Log.d("Status_Dominik", "Sending Click button sendButton");
            	
            	
            	RadioButton radio = (RadioButton) findViewById(radioGroup.getCheckedRadioButtonId());
            	if (radio == null) return;
            	
            	fileTransmitter.transmitFile((String) radio.getTag());
            	
            	
        	}
        });
    	
    	linear.addView(sendButton);
    	
    	
    	Button deleteButton = new Button(this);
    	deleteButton.setText(getString(R.string.deleteButton));
    	deleteButton.setOnClickListener(new OnClickListener() {
        	public void onClick(View v) {
            	Log.d("Status_Dominik", "Tagging Click button deleteButton");
            	
            	RadioButton radio = (RadioButton) findViewById(radioGroup.getCheckedRadioButtonId());
            	if (radio == null) return;
            	xmlCreator.deleteXmlFile((String)radio.getTag());
            	
            	Log.d("Status_Dominik", "Tagging Reload after delete");
            	sendingScreen();
        	}
        });
    	
    	linear.addView(deleteButton);
    	
    }
    
    
    /**
     * This formats us the time in a readable format 
     * @param date
     * @return String readable date format
     */
	private String dateFormat(Date date) {
		//return date.getDay() + "." + (date.getMonth() + 1) + "." + (date.getYear()+1900) + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
		
		DateFormat df = DateFormat.getDateTimeInstance( DateFormat.SHORT, DateFormat.SHORT );
		
		return df.format(date);
	}   
        
}