package de.Android_Seminar;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

import de.Android_Seminar.backend.SensorType;
import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.View.OnClickListener;
import android.widget.ToggleButton;


/**
 * @author Kai
 *
 * This Class provides us the properties and the properties view
 */
public class Properties extends Activity {

	//Properties Screen
	private SensorType[] sensorTyps = new SensorType[] {SensorType.PROXIMITY_SENSOR, SensorType.COMPASS, SensorType.ACCELEROMETER, SensorType.LIGHT_SENSOR, SensorType.AUDIO_SENSOR, SensorType.GPS_SENSOR, SensorType.GYROSKOPE};
	private ToggleButton[] toggleButtons = new ToggleButton[this.sensorTyps.length];
	private ToggleButton[] toggleButtonsPaint = new ToggleButton[this.sensorTyps.length];
	private boolean[] checked = new boolean[] {false, false, false, false, false, false, false};
	private boolean[] paint = new boolean[] {false, false, false , false, false, false, false};
	
	private List<SensorType> availableSensors = new ArrayList<SensorType>();
	

    /**
     *
     *  Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d("Status_Dominik", "Properties onCreate");
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        
        String sensor;
        
        // Restore preferences
        SharedPreferences settings = getSharedPreferences("logging_prefs", 0);
        for(int i=0; i<sensorTyps.length; i++) {
        	checked[i] = settings.getBoolean(sensorTyps[i].toString() + "-checked", false);
        	paint[i] = settings.getBoolean(sensorTyps[i].toString() + "-paint", false);
        	
        	sensor = settings.getString("available-" + i, "NULL");
        	
        	if(!sensor.equals("NULL")) {
        		availableSensors.add(SensorType.valueOf(sensor));
        	}
        	
        	
        }

        
        // prevent screen  
        setRequestedOrientation(1); 
        
        
        LoadScreen();
        
        
    }
    
   /**
    *
    *  Called when the activity will be Paused.
    */
    @Override
    public void onPause() {
    	super.onPause();
    	Log.d("Status_Dominik", "Properties onPause");
    	savePrefercense();
    	return;
    }
    
   /**
    *
    *  Called when the activity will be Stopped.
    */
	@Override
    protected void onStop(){
		super.onStop();
		Log.d("Status_Dominik", "Properties onStop");
		//savePrefercense();
		
	}
	
	/**
	 * This method save our properties with SharedPreferences
	 */
	public void savePrefercense(){
		// We need an Editor object to make preference changes.
		// All objects are from android.context.Context
		SharedPreferences settings = getSharedPreferences("logging_prefs", 0);
		SharedPreferences.Editor editor = settings.edit();
		for(int i=0; i<sensorTyps.length; i++) {
			editor.putBoolean(sensorTyps[i].toString() + "-checked", checked[i]);
			editor.putBoolean(sensorTyps[i].toString() + "-paint", paint[i]);
			}
		
		// Commit the edits!
		editor.commit();
	}

    
    
    /**
     * Create the Properties Screen with Listener for every Button
     */
    private void LoadScreen(){
    	setContentView(R.layout.properties);
    	
    	//ToogleButton Listener + setChecked
    	int ID = -1;
    	int ID_paint = -1;
    	
    	for(int i = 0; i < sensorTyps.length; i++) {
    		
    		switch (sensorTyps[i]) {
			case PROXIMITY_SENSOR:
				ID = R.id.toggle_proximity_sensor;
				ID_paint = R.id.paint_proximity_sensor;
				break;

			case COMPASS:
				ID = R.id.toggle_compass;
				ID_paint = R.id.paint_compass;
				break;
			
			case ACCELEROMETER:
				ID = R.id.toggle_accelerometer;
				ID_paint = R.id.paint_accelerometer;
				break;
				
			case LIGHT_SENSOR:
				ID = R.id.toggle_light_sensor;
				ID_paint = R.id.paint_light_sensor;
				break;
				
			case AUDIO_SENSOR:
				ID = R.id.toggle_audio_sensor;
				ID_paint = R.id.paint_audio_sensor;
				break;
				
			case GPS_SENSOR:
				ID = R.id.toggle_gps_sensor;
				ID_paint = R.id.paint_gps_sensor;
				break;
				
			case GYROSKOPE:
				ID = R.id.toggle_gyroskope;
				ID_paint = R.id.paint_gyroskope;
				break;
			
			default:
				ID = -1;
				ID_paint = -1;
				break;
			}
    		
    		final int point = i;
    		
    		
    		this.toggleButtons[i] = ((ToggleButton) this.findViewById(ID));
    		this.toggleButtonsPaint[i] = ((ToggleButton) this.findViewById(ID_paint));
    		
    		if(this.availableSensors == null || !this.availableSensors.contains(sensorTyps[i])) {
    			toggleProperties(this.toggleButtons[i], false, false);
    			toggleProperties(this.toggleButtonsPaint[i], false, false);
    			continue;
    		}
    		
    		
			toggleProperties(this.toggleButtonsPaint[i], this.paint[i], this.checked[i]);
    		this.toggleButtonsPaint[i].setOnClickListener(new OnClickListener() {
            	public void onClick(View v) {
            		paint[point] = toggleButtonsPaint[point].isChecked();
            	}
            });
    		

			toggleProperties(this.toggleButtons[i], this.checked[i], true);
    		this.toggleButtons[i].setOnClickListener(new OnClickListener() {
            	public void onClick(View v) {
            		checked[point] = toggleButtons[point].isChecked();
        			toggleButtonsPaint[point].setClickable(toggleButtons[point].isChecked());
        			toggleButtonsPaint[point].setEnabled(toggleButtons[point].isChecked());
            	}
            });
    		
    	}
    }
    
    /**
     * This method configure our Buttons
     * @param button which should be configured
     * @param checked
     * @param enable
     */
    private void toggleProperties(ToggleButton button, boolean checked, boolean enable) {
    	button.setChecked(checked);
		button.setClickable(enable);
		button.setEnabled(enable);
    }
}