/**
 * 
 */
package de.Android_Seminar;

import de.Android_Seminar.backend.SensorController;
import de.Android_Seminar.backend.SensorData;
import de.Android_Seminar.backend.SensorType;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.Log;
import android.widget.ImageView;

/**
 * @author Kai
 *
 * This class is responsible for drawing the diagram.
 * She first draws the coordinate system and then adds the points present a
 */
public class Graphics implements Runnable {
	
	// Available Colors for coordinate system
	int[] color = new int[] {Color.BLUE, Color.CYAN, Color.DKGRAY, Color.GRAY, Color.GREEN, Color.LTGRAY, Color.MAGENTA, Color.RED, Color.WHITE, Color.YELLOW};
	
	private Sensor_Logging_for_Mobility sensorLoggingForMobility;
	private SensorController sensorController;
	
	private boolean stop = false;
	
	private final int granularity = 4;
	private final double OUTER_BOUND_SPACE = 20.0;
	
	private ImageView imageView;
	private  int width;
	private  int height; 
	
	private double middle;
	
	private int freeSpace = 5;
	private int yAxesStart = 35;
	
	private Bitmap bitmap;
	private Paint paint;
	private Canvas canvas;

	/**
	 * Constructor
	 * @param Context context
	 * @param SensorController sensorController for getting the data's
	 * @param int width Width of the bitmap 
	 * @param int height Height of the bitmap
	 */
	public Graphics(Context context, SensorController sensorController, int width, int height) {
		
		Log.d("Status_Dominik", "Graphic Construtor");
		
		this.sensorLoggingForMobility = (Sensor_Logging_for_Mobility)context;
		this.sensorController = sensorController;
		
		//Create ImageView which should show our diagram
		this.imageView = new ImageView(context);
		//Set properties of ImageView
		
		//We'll be creating an image that is width pixel wide an height pixels tall.
//		this.height = height;
//		this.width = width;
		
		this.height = 370;
		this.width = 300;
		
		createBitmap();
	}
	
	/**
	 * This creates us the Canvas and Bitmap object for the diagram
	 */
	public void createBitmap() {
		
		
		// Create a bitmap with the dimensions we defined above, and with a 16-bit pixel format. We'll
		// get a little more in depth with pixel formats in a later post.
		this.bitmap = Bitmap.createBitmap(this.width, this.height, Config.RGB_565);
		
		
		//Make space for the legend
		this.height -=35;
		
		
		this.middle = this.height / 2.0;
		
		// Create a paint object for us to draw with, and set our drawing color to blue.
		this.paint = new Paint();
		this.paint.setColor(Color.WHITE);
		 
		// Create a new canvas to draw on, and link it to the bitmap that we created above. Any drawing
		// operations performed on the canvas will have an immediate effect on the pixel data of the
		// bitmap.
		this.canvas = new Canvas(bitmap);
		 
		// Fill the entire canvas with a red color.
		this.canvas.drawColor(Color.TRANSPARENT);
		 
		// Set this ImageView's bitmap to the one we have drawn to.
		this.imageView.setImageBitmap(bitmap);
		 
		return;
	}
	
	/**
	 * This print us the coordinate system
	 */
	public void diagramm() {
		// Draw a rectangle inside our image using the paint object we defined above. The rectangle's
		// upper left corner will be at (25,50), and the lower left corner will be at (75,150). Since we set
		// the paint object's color above, this rectangle will be blue.
//		this.canvas.drawRect(25, 50, 75, 150, paint);
		
		//Set Color for axis and labels
		this.paint.setColor(Color.WHITE);
		
		// Draw y-axis
		this.canvas.drawLine(this.yAxesStart, this.freeSpace, this.yAxesStart, this.height - this.freeSpace, this.paint);
		
		//Draw x-axis
		this.canvas.drawLine(this.freeSpace, (int) middle, this.width - this.freeSpace, (int) middle, this.paint);
		
		double point = 0;
		
		double textMiddle = this.middle + 5.0;
		
		for(int i=1; i<= this.granularity; i++) {
			
			point = 100 / this.granularity * (double)i;
			
			this.canvas.drawText((int)point+"%", 0, (int)(textMiddle - (textMiddle - OUTER_BOUND_SPACE) * (point / 100)), this.paint);
			this.canvas.drawText("-"+(int)point+"%", 0, (int)(textMiddle + (textMiddle - OUTER_BOUND_SPACE) * (point / 100)), this.paint);
			
			//this.imageView.postInvalidate();
		}
		
		
	}
	
	/**
	 * This insert the last 30 points in the coordinate system
	 */
	public void insertPoints() {
		
		int c =0;
		
		
		this.canvas.drawColor(0, android.graphics.PorterDuff.Mode.CLEAR);
		
		SensorData[] data;
		
		int maxValue;
		int minValue;
		
		int legendPositionX = 10;
		int legendPositiony = this.height + 30;
		
		String legendAffix = "";
		String legend;
		
		int lastValue = 0;
		int value = 0;
		
		double[] values;
		
		this.diagramm();
		
		SensorType[] sensors = this.sensorLoggingForMobility.getSensorTyps();
		boolean[] checked = this.sensorLoggingForMobility.getSensorsChecked();
		boolean[] toPaint = this.sensorLoggingForMobility.getSensorsPaint();
		
		for(int k=0; k<sensors.length; k++) {
			
			if(checked[k]==false || toPaint[k] == false) continue;
			
			Log.d("Status_Dominik", "Graphics Will painting:" + sensors[k].toString());
			
			data = this.sensorController.getBufferedData(sensors[k], 30);
			
			
			//TODO min und max Value korrekt setzen
			maxValue = 20;
			minValue = -20;
			

			
			double startX = this.yAxesStart;
			
			double step = ((double)this.width - this.yAxesStart - 2.0 * (double)this.freeSpace) / (double)data.length;
			
			if(data[0] == null) {
				Log.d("Status_Dominik", "Graphics " + sensors[k].toString() + " has at index 0 no data's");
				continue;
			}
			
			for(int j = 0; j < data[0].getLength(); j++) {
				Log.d("Status_Dominik", "Graphics " + sensors[k].toString() + " has " + data[0].getLength() + " Lines");
				lastValue = 0;
				//0x 1y 2z
				
				this.paint.setColor(color[c]);
				
				legendAffix = "";
				
				if(data.length > 1) legendAffix = (j == 0 ? "-X" : (j == 1 ? "-Y" : "-Z"));
				
				switch (data[0].getSensorType()) {
					case PROXIMITY_SENSOR:
						legend = "Proxy";
						break;
	
					case COMPASS:
						legend = "Com";
						break;
					
					case ACCELEROMETER:
						legend = "Acc";
						break;
						
					case LIGHT_SENSOR:
						legend = "Light";
						break;
						
					case AUDIO_SENSOR:
						legend = "Audio";
						break;
						
					case GPS_SENSOR:
						legend = "GPS";
						break;
						
					case GYROSKOPE:
						legend = "Gyro";
						break;
					
					default:
						legend = "";
						break;
				}
				
				if(legendPositionX + 45 > this.width) {
					legendPositionX = 10;
					legendPositiony -= 20;
				}
				
				this.canvas.drawText(legend + legendAffix, legendPositionX, legendPositiony, paint);
				
				legendPositionX += 45;
				
				for(int i = 0; i < data.length; i++) {
					
					if(data[i] == null) {
						Log.d("Status_Dominik", "Graphics " + sensors[k].toString() + " has at index " + i + " no data's");
						continue;
					}
					
					
					values = data[i].getValues();
					
					value = (int)values[j];
					
					if (0<= value) {
						if (value > maxValue) value %= maxValue;
						value = (int)((double)value * (this.middle - this.freeSpace) / Math.abs((double) maxValue)); 
					}
					if (0>value) {
						if (value < minValue) value %= minValue;
						value = (int)((double)value * (this.middle -this.freeSpace) / Math.abs((double) minValue)); 
					}
					
					
					if(i==0) { lastValue = value; continue;}
					
					this.canvas.drawLine((int)(startX + (step * ((double)i-1.0))), (int)this.middle - lastValue, (int)(startX + (step * (double)i)), (int)this.middle - value, paint);
								
					lastValue = value;
				}
				
				c++;
				if (c >= this.color.length){
					Log.d("Status_Dominik", "Graphics Not enough colors avaible. We have only " + this.color.length + " Colors");
					c=0;
				}
			}
		}
		
		
		this.imageView.postInvalidate();
		
		return;
	}
	
	/**
	 * This need we for execute the Thread
	 */
	public void run() {
		Log.d("Status_Dominik", "Graphics Start Painting");
		while(!stop) {
			
			try {
				Thread.sleep(30);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			
			this.insertPoints();
			
		}
		
		Log.d("Status_Dominik", "Graphics Stop Painting");
	}
	
	/**
	 * This give us the ImageView with the coordinate System
	 * 
	 * @return ImageView
	 */
	public ImageView getImageView() {
		return this.imageView;
		
	}
	
	/**
	 * This Method we need for stopping the Thread
	 */
	public void setStop() {
		this.stop = true;
		Log.d("Status_Dominik", "Graphics setStop");
		return;
	}
	
	/**
	 * This Method we need for starting the Thread
	 */
	public void setStart() {
		this.stop = false;
		Log.d("Status_Dominik", "Graphics setStart");
		return;
	}
	
	/**
	 * This method we need for resize the bitmap
	 * 
	 * @param height New Height of the Bitmap
	 * @param width New Width of the Bitmap
	 */
	public void setDimension(int height, int width){
		this.height = height;
		this.width = width;
		
		createBitmap();
		Log.d("Status_Dominik", "Graphics SetDimension");
		
		
	}
		
}
